/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.net.ARPPinger;
import net.azib.ipscan.core.net.CombinedUnprivilegedPinger;
import net.azib.ipscan.core.net.JavaPinger;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.core.net.TCPPinger;
import net.azib.ipscan.core.net.UDPPinger;
import net.azib.ipscan.di.InjectException;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.fetchers.FetcherException;
import net.azib.ipscan.fetchers.MACFetcher;

public class PingerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger();
    private ScannerConfig scannerConfig;
    private Injector injector;
    Map<String, Class<? extends Pinger>> pingers;

    public PingerRegistry(ScannerConfig scannerConfig, Injector injector) throws ClassNotFoundException {
        this.scannerConfig = scannerConfig;
        this.injector = injector;
        this.pingers = new LinkedHashMap<String, Class<? extends Pinger>>();
        if (Platform.WINDOWS) {
            this.pingers.put("pinger.windows", Class.forName(this.getClass().getPackage().getName() + ".WindowsPinger"));
        }
        this.pingers.put("pinger.udp", UDPPinger.class);
        this.pingers.put("pinger.tcp", TCPPinger.class);
        this.pingers.put("pinger.combined", CombinedUnprivilegedPinger.class);
        this.pingers.put("pinger.java", JavaPinger.class);
        this.pingers.put("pinger.arp", ARPPinger.class);
    }

    public String[] getRegisteredNames() {
        return this.pingers.keySet().toArray(new String[this.pingers.size()]);
    }

    public Pinger createPinger(boolean isLAN) throws FetcherException {
        Class<? extends Pinger> pingerClass = this.pingers.get(this.scannerConfig.selectedPinger);
        if (pingerClass == null) {
            Map.Entry<String, Class<? extends Pinger>> first = this.pingers.entrySet().iterator().next();
            this.scannerConfig.selectedPinger = first.getKey();
            pingerClass = first.getValue();
        }
        Pinger mainPinger = this.createPinger(pingerClass, this.scannerConfig.pingTimeout);
        if (isLAN) {
            return new ARPPinger(this.injector.require(MACFetcher.class), mainPinger);
        }
        return mainPinger;
    }

    Pinger createPinger(Class<? extends Pinger> pingerClass, int timeout) throws FetcherException {
        try {
            return this.injector.require(pingerClass);
        }
        catch (InjectException ie) {
            try {
                Constructor<? extends Pinger> constructor = pingerClass.getConstructor(Integer.TYPE);
                Pinger pinger = constructor.newInstance(timeout);
                this.injector.register(pingerClass, pinger);
                return pinger;
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
                String message = "Unable to create pinger: " + pingerClass.getSimpleName();
                LOG.log(Level.SEVERE, message, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new FetcherException("pingerCreateFailure");
            }
        }
    }
}

