/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.state;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateTransitionListener;

public abstract class StateMachine {
    private volatile ScanningState state = ScanningState.IDLE;
    private ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private List<StateTransitionListener> transitionListeners = new ArrayList<StateTransitionListener>();

    public boolean inState(ScanningState state) {
        return this.state == state;
    }

    public ScanningState getState() {
        return this.state;
    }

    public void addTransitionListener(StateTransitionListener listener) {
        try {
            this.listenersLock.writeLock().lock();
            this.transitionListeners.add(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    public void removeTransitionListener(StateTransitionListener listener) {
        try {
            this.listenersLock.writeLock().lock();
            this.transitionListeners.remove(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    void transitionTo(ScanningState newState, Transition transition) {
        if (this.state != newState) {
            this.state = newState;
            this.notifyAboutTransition(transition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAboutTransition(Transition transition) {
        try {
            this.listenersLock.readLock().lock();
            for (StateTransitionListener listener : this.transitionListeners) {
                listener.transitionTo(this.state, transition);
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
    }

    public void transitionToNext() {
        if (this.state != ScanningState.KILLING) {
            this.transitionTo(this.state.next(), Transition.NEXT);
        }
    }

    public void stop() {
        if (this.state == ScanningState.SCANNING) {
            this.transitionTo(ScanningState.STOPPING, Transition.STOP);
        } else if (this.state == ScanningState.STOPPING) {
            this.notifyAboutTransition(Transition.STOP);
        } else {
            throw new IllegalStateException("Attempt to stop from " + this.state);
        }
    }

    public void complete() {
        if (this.state != ScanningState.STOPPING && this.state != ScanningState.KILLING) {
            throw new IllegalStateException("Attempt to complete from " + this.state);
        }
        this.transitionTo(ScanningState.IDLE, Transition.COMPLETE);
    }

    public void rescan() {
        if (this.state != ScanningState.IDLE) {
            throw new IllegalStateException("Attempt to rescan from " + this.state);
        }
        this.transitionTo(ScanningState.RESTARTING, Transition.RESCAN);
    }

    public void startScanning() {
        if (this.state != ScanningState.STARTING && this.state != ScanningState.RESTARTING) {
            throw new IllegalStateException("Attempt to go scanning from " + this.state);
        }
        this.transitionTo(ScanningState.SCANNING, Transition.START);
    }

    public void continueScanning() {
        if (this.state != ScanningState.IDLE) {
            throw new IllegalStateException("Attempt to continue scanning from " + this.state);
        }
        this.transitionTo(ScanningState.STARTING, Transition.CONTINUE);
    }

    public void init() {
        this.state = ScanningState.IDLE;
        this.notifyAboutTransition(Transition.INIT);
    }

    public void reset() {
        this.state = ScanningState.IDLE;
    }

    public static enum Transition {
        INIT,
        START,
        STOP,
        NEXT,
        COMPLETE,
        RESET,
        RESCAN,
        CONTINUE;

    }
}

