/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.fetchers.PingFetcher;

public class PingTTLFetcher
extends PingFetcher {
    public PingTTLFetcher(PingerRegistry pingerRegistry, ScannerConfig scannerConfig) {
        super(pingerRegistry, scannerConfig);
    }

    @Override
    public String getId() {
        return "fetcher.ping.ttl";
    }

    @Override
    public Object scan(ScanningSubject subject) {
        PingResult result = this.executePing(subject);
        subject.setResultType(result.isAlive() ? ScanningResult.ResultType.ALIVE : ScanningResult.ResultType.DEAD);
        return result.isAlive() && result.getTTL() > 0 ? Integer.valueOf(result.getTTL()) : null;
    }
}

