/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.gui.MainWindow;
import net.azib.ipscan.gui.Startup;
import net.azib.ipscan.util.GoogleAnalytics;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GUI
implements AutoCloseable {
    static final Logger LOG = LoggerFactory.getLogger();
    private long startTime = System.currentTimeMillis();
    private Display display;
    private MainWindow mainWindow;

    public GUI() {
        try {
            Display.setAppName("Angry IP Scanner");
            this.display = Display.getDefault();
            LOG.finer("SWT initialized after " + (System.currentTimeMillis() - this.startTime));
        }
        catch (SWTError e) {
            if (e.getMessage().contains("gtk_init_check")) {
                System.err.println(e.toString() + ": probably you are running as `root` and/or don't have access to the X Server. Please run as normal user or with sudo.");
                new GoogleAnalytics().report(e);
            }
            if (e.getMessage().contains("Invalid thread access")) {
                System.err.println(e.toString() + ": you need to start Java with -XstartOnFirstThread on a Mac");
                new GoogleAnalytics().report(e);
            }
            throw e;
        }
    }

    public void showMainWindow(Injector injector, boolean showStartupInfo) {
        this.mainWindow = injector.require(MainWindow.class);
        LOG.fine("Main window created: " + (System.currentTimeMillis() - this.startTime));
        if (showStartupInfo) {
            injector.require(Startup.class).onStart();
        }
        while (!this.mainWindow.isDisposed()) {
            try {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (Exception e) {
                if (e instanceof SWTException && e.getCause() instanceof Exception) {
                    e = (Exception)e.getCause();
                }
                String localizedMessage = GUI.getLocalizedMessage(e);
                this.showMessage(e instanceof UserErrorException ? 8 : 1, Labels.getLabel(e instanceof UserErrorException ? "text.userError" : "text.error"), localizedMessage);
                if (e instanceof UserErrorException && e.getCause() == null) continue;
                new GoogleAnalytics().report(e);
            }
        }
    }

    public void showMessage(int flags, String title, String localizedMessage) {
        Shell parent = Display.getDefault().getActiveShell();
        if (parent == null && this.mainWindow != null) {
            parent = this.mainWindow.getShell();
        }
        if (parent == null || parent.isDisposed()) {
            parent = new Shell();
        }
        MessageBox messageBox = new MessageBox(parent, 0x10000020 | flags);
        messageBox.setText(title);
        messageBox.setMessage(localizedMessage);
        messageBox.open();
    }

    @Override
    public void close() {
        try {
            this.display.dispose();
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    static String getLocalizedMessage(Throwable e) {
        Object localizedMessage;
        try {
            String exceptionClassName = e.getClass().getSimpleName();
            String originalMessage = e.getMessage();
            localizedMessage = Labels.getLabel("exception." + exceptionClassName + (String)(originalMessage != null ? "." + originalMessage : ""));
            if (e.getCause() != null) {
                localizedMessage = (String)localizedMessage + "\n\n" + e.getCause().toString();
            }
            LOG.log(Level.FINE, "error", e);
        }
        catch (Exception e2) {
            localizedMessage = e.toString();
            LOG.log(Level.SEVERE, "unexpected error", e);
        }
        return localizedMessage;
    }
}

