/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Library;

public class SWT {
    public static final int MODIFIER_MASK;
    public static final int BUTTON_MASK;
    public static final int MOD1;
    public static final int MOD2;
    public static final int MOD3;
    public static final int MOD4;

    static {
        BUTTON_MASK = 45613056;
        MODIFIER_MASK = 4685824;
        String platform = SWT.getPlatform();
        if ("cocoa".equals(platform)) {
            MOD1 = 0x400000;
            MOD2 = 131072;
            MOD3 = 65536;
            MOD4 = 262144;
        } else {
            MOD1 = 262144;
            MOD2 = 131072;
            MOD3 = 65536;
            MOD4 = 0;
        }
    }

    static String findErrorText(int code) {
        switch (code) {
            case 1: {
                return "Unspecified error";
            }
            case 2: {
                return "No more handles";
            }
            case 3: {
                return "No more callbacks";
            }
            case 4: {
                return "Argument cannot be null";
            }
            case 5: {
                return "Argument not valid";
            }
            case 51: {
                return "Return value not valid";
            }
            case 6: {
                return "Index out of bounds";
            }
            case 7: {
                return "Argument cannot be zero";
            }
            case 8: {
                return "Cannot get item";
            }
            case 9: {
                return "Cannot get selection";
            }
            case 11: {
                return "Cannot get item height";
            }
            case 12: {
                return "Cannot get text";
            }
            case 13: {
                return "Cannot set text";
            }
            case 14: {
                return "Item not added";
            }
            case 15: {
                return "Item not removed";
            }
            case 20: {
                return "Not implemented";
            }
            case 21: {
                return "Menu must be a drop down";
            }
            case 22: {
                return "Invalid thread access";
            }
            case 24: {
                return "Widget is disposed";
            }
            case 27: {
                return "Menu item is not a CASCADE";
            }
            case 28: {
                return "Cannot set selection";
            }
            case 29: {
                return "Cannot set menu";
            }
            case 30: {
                return "Cannot set the enabled state";
            }
            case 31: {
                return "Cannot get the enabled state";
            }
            case 32: {
                return "Widget has the wrong parent";
            }
            case 33: {
                return "Menu is not a BAR";
            }
            case 36: {
                return "Cannot get count";
            }
            case 37: {
                return "Menu is not a POP_UP";
            }
            case 38: {
                return "Unsupported color depth";
            }
            case 39: {
                return "i/o error";
            }
            case 40: {
                return "Invalid image";
            }
            case 42: {
                return "Unsupported or unrecognized format";
            }
            case 43: {
                return "Subclassing not allowed";
            }
            case 44: {
                return "Graphic is disposed";
            }
            case 45: {
                return "Device is disposed";
            }
            case 49: {
                return "BrowserFunction is disposed";
            }
            case 46: {
                return "Failed to execute runnable";
            }
            case 50: {
                return "Failed to evaluate javascript expression";
            }
            case 47: {
                return "Unable to load library";
            }
            case 10: {
                return "Cannot invert matrix";
            }
            case 16: {
                return "Unable to load graphics library";
            }
            case 48: {
                return "Font not valid";
            }
        }
        return "Unknown error";
    }

    public static String getMessage(String key) {
        return Compatibility.getMessage(key);
    }

    public static String getPlatform() {
        return "cocoa";
    }

    public static int getVersion() {
        return Library.SWT_VERSION;
    }

    public static void error(int code) {
        SWT.error(code, null);
    }

    public static void error(int code, Throwable throwable) {
        SWT.error(code, throwable, null);
    }

    public static void error(int code, Throwable throwable, String detail) {
        if (code != 46) {
            if (throwable instanceof SWTError) {
                throw (SWTError)throwable;
            }
            if (throwable instanceof SWTException) {
                throw (SWTException)throwable;
            }
        }
        String message = SWT.findErrorText(code);
        if (detail != null) {
            message = String.valueOf(message) + detail;
        }
        switch (code) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 21: 
            case 27: 
            case 32: 
            case 33: 
            case 37: {
                throw new IllegalArgumentException(message);
            }
            case 10: 
            case 16: 
            case 22: 
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: {
                SWTException exception = new SWTException(code, message);
                exception.throwable = throwable;
                throw exception;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 47: {
                SWTError error = new SWTError(code, message);
                error.throwable = throwable;
                throw error;
            }
        }
        SWTError error = new SWTError(code, message);
        error.throwable = throwable;
        throw error;
    }
}

