/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableColumn;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableHeader;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTableRow;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

class TableAccessibleDelegate {
    Map childColumnToIdMap = new HashMap();
    Map childRowToIdMap = new HashMap();
    Accessible tableAccessible;
    AccessibleTableHeader headerAccessible;

    public TableAccessibleDelegate(Accessible accessible) {
        this.tableAccessible = accessible;
        this.tableAccessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            @Override
            public void getChildCount(AccessibleControlEvent e) {
                e.detail = TableAccessibleDelegate.this.childColumnToIdMap.size() + TableAccessibleDelegate.this.childRowToIdMap.size();
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    ++e.detail;
                }
            }

            @Override
            public void getChildren(AccessibleControlEvent e) {
                int childCount = TableAccessibleDelegate.this.childColumnToIdMap.size() + TableAccessibleDelegate.this.childRowToIdMap.size();
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    ++childCount;
                }
                Accessible[] children = new Accessible[childCount];
                int childIndex = 0;
                for (AccessibleTableRow row : TableAccessibleDelegate.this.childRowToIdMap.values()) {
                    children[childIndex++] = row;
                }
                for (AccessibleTableColumn col : TableAccessibleDelegate.this.childColumnToIdMap.values()) {
                    children[childIndex++] = col;
                }
                if (TableAccessibleDelegate.this.childColumnToIdMap.size() > 1) {
                    children[childIndex] = TableAccessibleDelegate.this.headerAccessible();
                }
                e.children = children;
            }

            @Override
            public void getChildAtPoint(AccessibleControlEvent e) {
                NSPoint testPoint = new NSPoint();
                testPoint.x = e.x;
                Monitor primaryMonitor = Display.getCurrent().getPrimaryMonitor();
                testPoint.y = primaryMonitor.getBounds().height - e.y;
                for (AccessibleTableRow row : TableAccessibleDelegate.this.childRowToIdMap.values()) {
                    NSValue locationValue = new NSValue(row.getPositionAttribute((int)-1).id);
                    NSPoint location = locationValue.pointValue();
                    NSValue sizeValue = new NSValue(row.getSizeAttribute(-1));
                    NSSize size = sizeValue.sizeValue();
                    if (!(location.y < testPoint.y) || !(testPoint.y < location.y + size.height)) continue;
                    AccessibleControlEvent e2 = new AccessibleControlEvent(e.getSource());
                    e2.x = (int)testPoint.x;
                    e2.y = (int)testPoint.y;
                    row.getChildAtPoint(e);
                    break;
                }
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                NSNumber focusedObject;
                int state = 0x300000;
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                int i = 0;
                while (i < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size()) {
                    AccessibleTableListener listener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i);
                    listener.getSelectedRows(event);
                    ++i;
                }
                if (event.selected != null) {
                    int[] selected = event.selected;
                    int i2 = 0;
                    while (i2 < selected.length) {
                        if (selected[i2] == TableAccessibleDelegate.this.tableAccessible.index) {
                            state |= 2;
                            break;
                        }
                        ++i2;
                    }
                }
                if ((focusedObject = (NSNumber)TableAccessibleDelegate.this.tableAccessible.getFocusedAttribute(-1)).boolValue()) {
                    state |= 4;
                }
                e.detail = state;
            }
        });
        this.tableAccessible.addAccessibleTableListener(new AccessibleTableAdapter(){

            @Override
            public void getColumnCount(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                int i = 0;
                while (i < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size()) {
                    AccessibleTableListener listener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i);
                    if (listener != this) {
                        listener.getColumnCount(event);
                    }
                    ++i;
                }
                e.count = event.count;
            }

            @Override
            public void getColumn(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                this.getColumns(event);
                e.accessible = event.accessibles[e.column];
            }

            @Override
            public void getColumns(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                this.getColumnCount(event);
                if (event.count != TableAccessibleDelegate.this.childColumnToIdMap.size()) {
                    TableAccessibleDelegate.this.childColumnToIdMap.clear();
                }
                Accessible[] columns = new Accessible[event.count];
                int i = 0;
                while (i < event.count) {
                    columns[i] = TableAccessibleDelegate.this.childColumnToOs(i);
                    ++i;
                }
                int columnCount = TableAccessibleDelegate.this.childColumnToIdMap.size() > 0 ? TableAccessibleDelegate.this.childColumnToIdMap.size() : 1;
                Accessible[] accessibles = new Accessible[columnCount];
                int i2 = 0;
                while (i2 < columnCount) {
                    accessibles[i2] = (Accessible)TableAccessibleDelegate.this.childColumnToIdMap.get(i2);
                    ++i2;
                }
                e.accessibles = accessibles;
            }

            @Override
            public void getColumnHeader(AccessibleTableEvent e) {
                e.accessible = TableAccessibleDelegate.this.childColumnToIdMap.size() > 1 ? TableAccessibleDelegate.this.headerAccessible() : null;
            }

            @Override
            public void getRowCount(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                int i = 0;
                while (i < TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.size()) {
                    AccessibleTableListener listener = TableAccessibleDelegate.this.tableAccessible.accessibleTableListeners.get(i);
                    if (listener != this) {
                        listener.getRowCount(event);
                    }
                    ++i;
                }
                e.count = event.count;
            }

            @Override
            public void getRow(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                this.getRows(event);
                e.accessible = event.accessibles[e.row];
            }

            @Override
            public void getRows(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                this.getRowCount(event);
                if (event.count != TableAccessibleDelegate.this.childRowToIdMap.size()) {
                    TableAccessibleDelegate.this.childRowToIdMap.clear();
                }
                Accessible[] rows = new Accessible[event.count];
                int i = 0;
                while (i < event.count) {
                    rows[i] = TableAccessibleDelegate.this.childRowToOs(i);
                    ++i;
                }
                int columnCount = TableAccessibleDelegate.this.childRowToIdMap.size() > 0 ? TableAccessibleDelegate.this.childRowToIdMap.size() : 1;
                Accessible[] accessibles = new Accessible[columnCount];
                int i2 = 0;
                while (i2 < columnCount) {
                    accessibles[i2] = (Accessible)TableAccessibleDelegate.this.childRowToIdMap.get(i2);
                    ++i2;
                }
                e.accessibles = accessibles;
            }
        });
    }

    Accessible childColumnToOs(int childID) {
        if (childID == -1) {
            return this.tableAccessible;
        }
        AccessibleTableColumn childRef = (AccessibleTableColumn)this.childColumnToIdMap.get(childID);
        if (childRef == null) {
            childRef = new AccessibleTableColumn(this.tableAccessible, childID);
            this.childColumnToIdMap.put(childID, childRef);
        }
        return childRef;
    }

    Accessible childRowToOs(int childID) {
        if (childID == -1) {
            return this.tableAccessible;
        }
        AccessibleTableRow childRef = (AccessibleTableRow)this.childRowToIdMap.get(childID);
        if (childRef == null) {
            childRef = new AccessibleTableRow(this.tableAccessible, childID);
            this.childRowToIdMap.put(childID, childRef);
        }
        return childRef;
    }

    AccessibleTableHeader headerAccessible() {
        if (this.headerAccessible == null) {
            this.headerAccessible = new AccessibleTableHeader(this.tableAccessible, -1);
        }
        return this.headerAccessible;
    }

    void release() {
        SWTAccessibleDelegate childDelegate;
        Iterator iter;
        Collection delegates;
        if (this.childRowToIdMap != null) {
            delegates = this.childRowToIdMap.values();
            iter = delegates.iterator();
            while (iter.hasNext()) {
                childDelegate = ((Accessible)iter.next()).delegate;
                if (childDelegate == null) continue;
                childDelegate.internal_dispose_SWTAccessibleDelegate();
                childDelegate.release();
            }
            this.childRowToIdMap.clear();
            this.childRowToIdMap = null;
        }
        if (this.childColumnToIdMap != null) {
            delegates = this.childColumnToIdMap.values();
            iter = delegates.iterator();
            while (iter.hasNext()) {
                childDelegate = ((Accessible)iter.next()).delegate;
                if (childDelegate == null) continue;
                childDelegate.internal_dispose_SWTAccessibleDelegate();
                childDelegate.release();
            }
            this.childColumnToIdMap.clear();
            this.childColumnToIdMap = null;
        }
    }
}

