/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;

public final class GC
extends Resource {
    public NSGraphicsContext handle;
    Drawable drawable;
    GCData data;
    GCTextData.Cache textDataCache = new GCTextData.Cache(20);
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            GCData data = new GCData();
            data.style = GC.checkStyle(style);
            long contextId = drawable.internal_new_GC(data);
            Device device = data.device;
            if (device == null) {
                device = Device.getDevice();
            }
            if (device == null) {
                SWT.error(4);
            }
            this.device = data.device = device;
            this.init(drawable, data, contextId);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC cocoa_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long context = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, context);
        return gc;
    }

    NSAutoreleasePool checkGC(int mask) {
        NSColor fg;
        double[] color;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        if (this.data.flippedContext != null && !this.handle.isEqual(NSGraphicsContext.currentContext())) {
            this.data.restoreContext = true;
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(this.handle);
        }
        if ((mask & 0xC00) != 0) {
            NSView view = this.data.view;
            if ((this.data.state & 0x400) == 0 || (this.data.state & 0x800) == 0 || (this.data.state & 0x1000) == 0) {
                boolean antialias = this.handle.shouldAntialias();
                this.handle.restoreGraphicsState();
                this.handle.saveGraphicsState();
                this.handle.setShouldAntialias(antialias);
                if (!(view == null || this.data.paintRect != null && view.isFlipped())) {
                    NSAffineTransform transform = NSAffineTransform.transform();
                    NSRect rect = view.convertRect_toView_(view.bounds(), null);
                    if (this.data.paintRect == null) {
                        transform.translateXBy(rect.x, rect.y + rect.height);
                    } else {
                        transform.translateXBy(0.0, rect.height);
                    }
                    transform.scaleXBy(1.0, -1.0);
                    transform.concat();
                    if (this.data.visibleRgn != 0L) {
                        if (this.data.visiblePath == null || (this.data.state & 0x1000) == 0) {
                            if (this.data.visiblePath != null) {
                                this.data.visiblePath.release();
                            }
                            this.data.visiblePath = Region.cocoa_new(this.device, this.data.visibleRgn).getPath();
                        }
                        this.data.visiblePath.addClip();
                        this.data.state |= 0x1000;
                    }
                }
                if (this.data.clipPath != null) {
                    this.data.clipPath.addClip();
                }
                if (this.data.transform != null) {
                    this.data.transform.concat();
                }
                mask &= 0xFFFFF3FF;
                this.data.state |= 0xC00;
                this.data.state &= 0xFFFFFFFC;
            }
        }
        OS.CGContextSetBlendMode(this.handle.graphicsPort(), this.data.xorMode ? 10 : 0);
        int state = this.data.state;
        if ((state & mask) == mask) {
            return pool;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        if ((state & 1) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setStroke();
                }
            } else {
                color = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                fg = this.data.fg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                fg.retain();
                fg.setStroke();
            }
        }
        if ((state & 0x100) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                color = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                fg = this.data.fg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                fg.retain();
                fg.setFill();
            }
            this.data.state &= 0xFFFFFFFD;
        }
        if ((state & 2) != 0) {
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                color = this.data.background;
                if (this.data.bg != null) {
                    this.data.bg.release();
                }
                NSColor bg = this.data.bg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                bg.retain();
                bg.setFill();
            }
            this.data.state &= 0xFFFFFEFF;
        }
        NSBezierPath path = this.data.path;
        if ((state & 0x40) != 0) {
            path.setLineWidth(this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                double[] lengths = new double[dashes.length];
                int i = 0;
                while (i < lengths.length) {
                    lengths[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                path.setLineDash(lengths, lengths.length, this.data.lineDashesOffset);
            } else {
                path.setLineDash(null, 0L, 0.0);
            }
        }
        if ((state & 0x80) != 0) {
            path.setMiterLimit(this.data.lineMiterLimit);
        }
        if ((state & 0x20) != 0) {
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 0;
                    break;
                }
                case 2: {
                    joinStyle = 1;
                    break;
                }
                case 3: {
                    joinStyle = 2;
                }
            }
            path.setLineJoinStyle(joinStyle);
        }
        if ((state & 0x10) != 0) {
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 1;
                    break;
                }
                case 1: {
                    capStyle = 0;
                    break;
                }
                case 3: {
                    capStyle = 2;
                }
            }
            path.setLineCapStyle(capStyle);
        }
        if ((state & 0x200) != 0) {
            double strokeWidth;
            double scaling;
            this.data.drawYOffset = 0.0;
            this.data.drawXOffset = 0.0;
            NSSize size = new NSSize();
            size.height = 1.0;
            size.width = 1.0;
            if (this.data.transform != null) {
                size = this.data.transform.transformSize(size);
            }
            if ((scaling = size.width) < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.drawXOffset = 0.5 / scaling;
            }
            if ((scaling = size.height) < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.drawYOffset = 0.5 / scaling;
            }
        }
        return pool;
    }

    @Override
    void destroy() {
        Image image = this.data.image;
        if (image != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if (this.data.textStorage != null) {
            this.data.textStorage.release();
        }
        this.data.textStorage = null;
        this.data.layoutManager = null;
        this.data.textContainer = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        if (this.data.path != null) {
            this.data.path.release();
        }
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
        }
        if (this.data.visiblePath != null) {
            this.data.visiblePath.release();
        }
        if (this.data.transform != null) {
            this.data.transform.release();
        }
        if (this.data.inverseTransform != null) {
            this.data.inverseTransform.release();
        }
        this.data.visiblePath = null;
        this.data.clipPath = null;
        this.data.path = null;
        this.data.inverseTransform = null;
        this.data.transform = null;
        this.data.bg = null;
        this.data.fg = null;
        this.textDataCache.release();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle.id, this.data);
        }
        this.handle.restoreGraphicsState();
        this.handle.release();
        this.drawable = null;
        this.data.image = null;
        this.data = null;
        this.handle = null;
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        NSImage imageHandle = srcImage.handle;
        NSSize size = imageHandle.size();
        int imgWidth = (int)size.width;
        int imgHeight = (int)size.height;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            if (srcImage.memGC != null) {
                srcImage.createAlpha();
            }
            this.handle.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.scaleXBy(1.0, -1.0);
            transform.translateXBy(0.0, -(destHeight + 2 * destY));
            transform.concat();
            NSRect srcRect = new NSRect();
            srcRect.x = srcX;
            srcRect.y = imgHeight - (srcY + srcHeight);
            srcRect.width = srcWidth;
            srcRect.height = srcHeight;
            NSRect destRect = new NSRect();
            destRect.x = destX;
            destRect.y = destY;
            destRect.width = destWidth;
            destRect.height = destHeight;
            imageHandle.drawInRect(destRect, srcRect, 2L, (float)this.data.alpha / 255.0f);
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    /*
     * Unable to fully structure code
     */
    void fillPattern(NSBezierPath path, Pattern pattern) {
        block7: {
            this.handle.saveGraphicsState();
            path.addClip();
            bounds = path.bounds();
            start = new NSPoint();
            start.x = pattern.pt1.x;
            start.y = pattern.pt1.y;
            end = new NSPoint();
            end.x = pattern.pt2.x;
            end.y = pattern.pt2.y;
            difx = end.x - start.x;
            dify = end.y - start.y;
            if (difx == 0.0 && dify == 0.0) {
                color = pattern.color1;
                NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f).setFill();
                path.fill();
                this.handle.restoreGraphicsState();
                return;
            }
            if (difx == 0.0 || dify == 0.0) {
                startx = bounds.x;
                starty = bounds.y;
                endx = bounds.x + bounds.width;
                endy = bounds.y + bounds.height;
                if (difx < 0.0 || dify < 0.0) {
                    startx = endx;
                    starty = endy;
                    endx = bounds.x;
                    endy = bounds.y;
                }
            } else {
                m = (end.y - start.y) / (end.x - start.x);
                b = end.y - m * end.x;
                m2 = -1.0 / m;
                b2 = bounds.y - m2 * bounds.x;
                startx = endx = (b - b2) / (m2 - m);
                b2 = bounds.y + bounds.height - m2 * bounds.x;
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                b2 = bounds.y - m2 * (bounds.x + bounds.width);
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                b2 = bounds.y + bounds.height - m2 * (bounds.x + bounds.width);
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                starty = m * startx + b;
                endy = m * endx + b;
            }
            if (difx == 0.0) ** GOTO lbl56
            while (difx > 0.0 && start.x >= startx || difx < 0.0 && start.x <= startx) {
                start.x -= difx;
                start.y -= dify;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                start.x -= difx;
                start.y -= dify;
lbl56:
                // 2 sources

                ** while (dify > 0.0 && start.y >= starty || dify < 0.0 && start.y <= starty)
            }
        }
        end.x = start.x;
        end.y = start.y;
        do {
            end.x += difx;
            end.y += dify;
            pattern.gradient.drawFromPoint(start, end, 0L);
            start.x = end.x;
            start.y = end.y;
        } while (difx > 0.0 && end.x <= endx || difx < 0.0 && end.x >= endx || difx == 0.0 && (dify > 0.0 && end.y <= endy || dify < 0.0 && end.y >= endy));
        this.handle.restoreGraphicsState();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            NSBezierPath path = this.data.path;
            path.appendBezierPathWithRect(rect);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    void flush() {
        this.handle.flushGraphics();
    }

    public Color getForeground() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return Color.cocoa_new(this.data.device, this.data.foreground);
    }

    public GCData getGCData() {
        if (this.handle == null) {
            SWT.error(24);
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        this.uncheckGC(pool);
        return this.data;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(Drawable drawable, GCData data, long context) {
        if (data.foreground != null) {
            data.state &= 0xFFFFFEFE;
        }
        if (data.background != null) {
            data.state &= 0xFFFFFFFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        data.state &= 0xFFFFFDFF;
        Image image = data.image;
        if (image != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = new NSGraphicsContext(context);
        this.handle.retain();
        this.handle.saveGraphicsState();
        data.path = NSBezierPath.bezierPath();
        data.path.setWindingRule(data.fillRule == 2 ? 0 : 1);
        data.path.retain();
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public void setAntialias(int antialias) {
        if (this.handle == null) {
            SWT.error(44);
        }
        boolean mode = true;
        switch (antialias) {
            case -1: {
                if (this.handle.isDrawingToScreen()) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
                break;
            }
            case 1: {
                mode = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = antialias;
        this.handle.setShouldAntialias(mode);
    }

    public void setBackground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        this.data.bg = null;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            NSBezierPath path = NSBezierPath.bezierPathWithRect(rect);
            path.retain();
            this.setClipping(path);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void setClipping(NSBezierPath path) {
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
            this.data.clipPath = null;
        }
        if (path != null) {
            this.data.clipPath = path;
            if (this.data.transform != null) {
                this.data.clipPath.transformUsingAffineTransform(this.data.transform);
            }
        }
        this.data.state &= 0xFFFFFBFF;
    }

    public void setFont(Font font) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        this.data.fg = null;
        this.data.state &= 0xFFFFFEFE;
    }

    void setPatternPhase(Pattern pattern) {
        if (pattern.image == null) {
            return;
        }
        NSPoint phase = new NSPoint();
        if (this.data.image != null) {
            phase.y += this.data.image.handle.size().height - pattern.image.handle.size().height;
        } else if (this.data.view != null) {
            NSView view = this.data.view;
            if (!view.isFlipped()) {
                phase.y = view.bounds().height;
            }
            NSView contentView = view.window().contentView();
            phase = view.convertPoint_toView_(phase, contentView);
            phase.y = contentView.bounds().height - phase.y;
        } else if (this.data.size != null) {
            phase.y += this.data.size.height - pattern.image.handle.size().height;
        }
        this.handle.setPatternPhase(phase);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    void uncheckGC(NSAutoreleasePool pool) {
        NSView view;
        if (this.data.flippedContext != null && this.data.restoreContext) {
            NSGraphicsContext.static_restoreGraphicsState();
            this.data.restoreContext = false;
        }
        if ((view = this.data.view) != null && this.data.paintRect == null && this.data.thread != Thread.currentThread()) {
            this.flush();
        }
        if (pool != null) {
            pool.release();
        }
    }

    private static class GCTextData {
        private NSLayoutManager layoutManager;
        private NSTextStorage textStorage;

        public void release() {
            if (this.textStorage != null) {
                this.textStorage.release();
            }
            this.textStorage = null;
            this.layoutManager = null;
        }

        private static class Cache {
            private final int cacheSize;
            private final Map<String, GCTextData> cache = new LinkedHashMap<String, GCTextData>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, GCTextData> eldest) {
                    if (this.size() >= cacheSize) {
                        eldest.getValue().release();
                        return true;
                    }
                    return false;
                }
            };

            public Cache(int cacheSize) {
                this.cacheSize = cacheSize;
            }

            public void release() {
                for (GCTextData data : this.cache.values()) {
                    data.release();
                }
                this.cache.clear();
            }
        }
    }
}

