/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAffineTransformStruct;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSThread;

public class Transform
extends Resource {
    public NSAffineTransform handle;

    @Override
    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransformStruct struct = this.handle.transformStruct();
            elements[0] = (float)struct.m11;
            elements[1] = (float)struct.m12;
            elements[2] = (float)struct.m21;
            elements[3] = (float)struct.m22;
            elements[4] = (float)struct.tX;
            elements[5] = (float)struct.tY;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + ", " + elements[1] + ", " + elements[2] + ", " + elements[3] + ", " + elements[4] + ", " + elements[5] + "}";
    }
}

