/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;

public final class Program {
    String name;
    String identifier;

    Program() {
    }

    static NSURL getURL(String fileName) {
        String lowercaseName = fileName.toLowerCase();
        NSString unescapedStr = lowercaseName.startsWith("http://") || lowercaseName.startsWith("https://") || lowercaseName.startsWith("file:/") ? NSString.stringWith("%#") : NSString.stringWith("%");
        NSString fullPath = NSString.stringWith(fileName);
        if (NSFileManager.defaultManager().fileExistsAtPath(fullPath)) {
            fullPath = NSURL.fileURLWithPath(fullPath).absoluteString();
        }
        long ptr = OS.CFURLCreateStringByAddingPercentEscapes(0L, fullPath.id, unescapedStr.id, 0L, 0x8000100);
        NSString escapedString = new NSString(ptr);
        NSURL url = NSURL.URLWithString(escapedString);
        OS.CFRelease(ptr);
        return url;
    }

    static boolean isExecutable(String fileName) {
        long ptr = C.malloc(1L);
        NSString path = NSString.stringWith(fileName);
        boolean result = false;
        NSFileManager manager = NSFileManager.defaultManager();
        if (manager.fileExistsAtPath(path, ptr)) {
            byte[] isDirectory = new byte[1];
            C.memmove(isDirectory, ptr, 1L);
            if (isDirectory[0] == 0 && manager.isExecutableFileAtPath(path)) {
                NSWorkspace ws = NSWorkspace.sharedWorkspace();
                NSString type = ws.typeOfFile(path, 0L);
                result = type != null && (ws.type(type, NSString.stringWith("public.unix-executable")) || OS.UTTypeEqual(type.id, NSString.stringWith((String)"public.shell-script").id));
            }
        }
        C.free(ptr);
        return result;
    }

    public static boolean launch(String fileName) {
        return Program.launch(fileName, null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean launch(String fileName, String workingDir) {
        if (fileName == null) {
            SWT.error(4);
        }
        pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            if (workingDir != null && Program.isExecutable(fileName)) {
                try {
                    Compatibility.exec(new String[]{fileName}, null, workingDir);
                    return true;
                }
                catch (IOException v0) {
                    ** try [egrp 2[TRYBLOCK] [2 : 55->56)] { 
lbl11:
                    // 1 sources

                    pool.release();
                    return false;
                }
            }
            url = Program.getURL(fileName);
            workspace = NSWorkspace.sharedWorkspace();
            var6_5 = workspace.openURL(url);
            return var6_5;
lbl-1000:
            // 1 sources

            {
                catch (Throwable var5_6) {
                    throw var5_6;
                }
            }
        }
        finally {
            pool.release();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.identifier.equals(program.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.identifier.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

