/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int nWidth = this.width;
        int nHeight = this.height;
        if (nWidth <= 0) {
            nWidth = 1;
        }
        if (this.image != null) {
            NSSize size = this.image.handle.size();
            nWidth = (int)size.width;
            nHeight = (int)size.height;
        }
        NSRect rect = new NSRect();
        rect.x = this.x;
        rect.y = this.y;
        rect.width = nWidth;
        rect.height = nHeight;
        this.parent.view.setNeedsDisplayInRect(rect);
        return true;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

