/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    Image image;
    Image[] images = new Image[0];
    Menu menuBar;
    String text = "";
    boolean minimized;
    boolean maximized;
    Control savedFocus;
    Button defaultButton;

    Decorations() {
    }

    static int checkStyle(int style) {
        if ((style & 8) != 0) {
            style &= 0xFFFFF30F;
        } else if ((style & 0x800000) != 0) {
            style |= 0x20;
        }
        if ((style & 0x4C0) != 0) {
            style |= 0x20;
        }
        return style;
    }

    void bringToTop(boolean force) {
        this.moveAbove(null);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Widget computeTabGroup() {
        return this;
    }

    @Override
    Control computeTabRoot() {
        return this;
    }

    void fixDecorations(Decorations newDecorations, Control control, Menu[] menus) {
        if (this == newDecorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (menus == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            int index = 0;
            while (index < menus.length) {
                if (menus[index] == menu) {
                    control.setMenu(null);
                    return;
                }
                ++index;
            }
            menu.fixMenus(newDecorations);
        }
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    @Override
    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    @Override
    boolean isTabItem() {
        return false;
    }

    @Override
    Decorations menuShell() {
        return this;
    }

    @Override
    void releaseChildren(boolean destroy) {
        Display display;
        if (this.menuBar != null) {
            this.menuBar.dispose();
            this.menuBar = null;
        }
        if ((display = this.display) == null || display.isDisposed()) {
            return;
        }
        super.releaseChildren(destroy);
        Menu[] menus = display.getMenus(this);
        if (menus != null) {
            int i = 0;
            while (i < menus.length) {
                Menu menu = menus[i];
                if (menu != null && !menu.isDisposed()) {
                    menu.dispose();
                }
                ++i;
            }
            menus = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.defaultButton = null;
    }

    @Override
    void reskinChildren(int flags) {
        Menu[] menus;
        if (this.menuBar != null) {
            this.menuBar.reskin(flags);
        }
        if ((menus = this.display.getMenus(this)) != null) {
            int i = 0;
            while (i < menus.length) {
                Menu menu = menus[i];
                if (menu != null) {
                    menu.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        if (this.savedFocus == null) {
            return false;
        }
        return this.savedFocus.setFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl(this.view.window());
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
            if ((button.style & 8) == 0) {
                return;
            }
        }
        if (button == this.defaultButton) {
            return;
        }
        this.defaultButton = button;
        NSButtonCell cell = null;
        if (this.defaultButton != null && (this.defaultButton.style & 8) != 0) {
            cell = new NSButtonCell(((NSButton)this.defaultButton.view).cell());
        }
        this.view.window().setDefaultButtonCell(cell);
        this.display.updateDefaultButton();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (this.parent != null) {
            return;
        }
        if (this.display.dockImage == null) {
            this.display.application.setApplicationIconImage(image != null ? image.handle : null);
        }
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        this.maximized = maximized;
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        this.menuBar = menu;
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    @Override
    boolean traverseItem(boolean next) {
        return false;
    }

    @Override
    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

