/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.SWTTabView;
import org.eclipse.swt.internal.cocoa.SWTTabViewItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    int itemCount;
    boolean ignoreSelect;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (wHint == -1 && this.items.length > 0) {
            NSSize minSize = ((NSTabView)this.view).minimumSize();
            Rectangle trim = this.computeTrim(0, 0, (int)Math.ceil(minSize.width), 0);
            size.x = Math.max(trim.width, size.x);
        }
        return size;
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        NSTabView widget = (NSTabView)this.view;
        NSRect rect = widget.contentRect();
        x = (int)((double)x - rect.x);
        y = (int)((double)y - rect.y);
        NSRect frame = widget.frame();
        width = (int)((double)width + Math.ceil(frame.width - rect.width));
        height = (int)((double)height + Math.ceil(frame.height - rect.height));
        return super.computeTrim(x, y, width, height);
    }

    @Override
    void createHandle() {
        NSTabView widget = (NSTabView)new SWTTabView().alloc();
        widget.init();
        widget.setDelegate(widget);
        if ((this.style & 0x400) != 0) {
            widget.setTabViewType(2L);
        }
        this.view = widget;
    }

    void createItem(TabItem item, int index) {
        NSTabViewItem nsItem;
        int count = this.itemCount;
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        ++this.itemCount;
        item.nsItem = nsItem = (NSTabViewItem)new SWTTabViewItem().alloc().init();
        item.createJNIRef();
        item.register();
        ((NSTabView)this.view).insertTabViewItem(nsItem, index);
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tabViewFont;
    }

    void destroyItem(TabItem item) {
        int count = this.itemCount;
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new TabItem[4];
        }
        this.itemCount = count;
        ((NSTabView)this.view).removeTabViewItem(item.nsItem);
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    @Override
    Widget findTooltip(NSPoint pt) {
        NSTabViewItem nsItem = ((NSTabView)this.view).tabViewItemAtPoint(pt = this.view.convertPoint_fromView_(pt, null));
        if (nsItem != null) {
            int i = 0;
            while (i < this.itemCount) {
                TabItem item = this.items[i];
                if (item.nsItem.id == nsItem.id) {
                    return item;
                }
                ++i;
            }
        }
        return super.findTooltip(pt);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkWidget();
        NSRect rect = ((NSTabView)this.view).contentRect();
        int x = Math.max(0, (int)rect.x);
        int y = Math.max(0, (int)rect.y);
        int width = Math.max(0, (int)Math.ceil(rect.width));
        int height = Math.max(0, (int)Math.ceil(rect.height));
        return new Rectangle(x, y, width, height);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        int count = this.itemCount;
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTabViewItem selected = ((NSTabView)this.view).selectedTabViewItem();
        if (selected == null) {
            return -1;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i].nsItem.id == selected.id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    float getThemeAlpha() {
        return (this.background != null ? 1.0f : 0.25f) * this.parent.getThemeAlpha();
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = this.itemCount;
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            int count = this.itemCount;
            while (index < count) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == count) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                TabItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        int count = this.itemCount;
        int i = 0;
        while (i < count) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                TabItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setFont(NSFont font) {
        ((NSTabView)this.view).setFont(font);
        int index = this.getSelectionIndex();
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].updateText(i == index);
            ++i;
        }
    }

    @Override
    void setForeground(double[] color) {
        super.setForeground(color);
        int index = this.getSelectionIndex();
        int i = 0;
        while (i < this.itemCount) {
            this.items[i].updateText(i == index);
            ++i;
        }
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false, false);
                }
                --i;
            }
        }
    }

    public void setSelection(int index) {
        this.checkWidget();
        int count = this.itemCount;
        if (index < 0 || index >= count) {
            return;
        }
        this.setSelection(index, false, false);
    }

    void setSelection(int index, boolean notify, boolean force) {
        Control control;
        TabItem item;
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        int currentIndex = this.getSelectionIndex();
        if (!force && currentIndex == index) {
            return;
        }
        if (currentIndex != -1 && (item = this.items[currentIndex]) != null && (control = item.control) != null && !control.isDisposed()) {
            control.setVisible(false);
        }
        this.ignoreSelect = true;
        ((NSTabView)this.view).selectTabViewItemAtIndex(index);
        this.ignoreSelect = false;
        index = this.getSelectionIndex();
        if (index != -1 && (item = this.items[index]) != null) {
            control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    @Override
    void setSmallSize() {
        ((NSTabView)this.view).setControlSize(1L);
    }

    @Override
    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true, false);
        return index == this.getSelectionIndex();
    }

    @Override
    void tabView_willSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
        if (tabViewItem == 0L) {
            return;
        }
        int i = 0;
        while (i < this.itemCount) {
            TabItem item = this.items[i];
            if (item.nsItem.id == tabViewItem) {
                Control control;
                TabItem selected;
                int currentIndex = this.getSelectionIndex();
                if (currentIndex != -1 && (selected = this.items[currentIndex]) != null) {
                    selected.updateText(false);
                    Control control2 = selected.control;
                    if (control2 != null && !control2.isDisposed()) {
                        control2.setVisible(false);
                    }
                }
                if ((control = item.control) != null && !control.isDisposed()) {
                    control.setVisible(true);
                }
                item.updateText(true);
                break;
            }
            ++i;
        }
    }

    @Override
    void tabView_didSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
        if (tabViewItem == 0L) {
            return;
        }
        int i = 0;
        while (i < this.itemCount) {
            NSView topView;
            TabItem item = this.items[i];
            Control control = item.control;
            if (control != null && (topView = control.topView()).superview() == null) {
                this.contentView().addSubview(topView, -1L, null);
            }
            if (item.nsItem.id == tabViewItem && !this.ignoreSelect) {
                Event event = new Event();
                event.item = item;
                this.sendSelectionEvent(13, event, false);
            }
            ++i;
        }
    }
}

