/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDockTile;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    NSImage defaultImage;
    int progress;
    int iProgress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    Menu menu;

    TaskItem(TaskBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, -1);
        this.createWidget();
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget() {
        NSApplication app = NSApplication.sharedApplication();
        NSImage image = app.applicationIconImage();
        this.defaultImage = new NSImage(image.copy());
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        if (this.defaultImage != null) {
            this.defaultImage.release();
        }
        this.defaultImage = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
        this.shell = null;
    }

    public void setProgress(int progress) {
        this.checkWidget();
        progress = Math.max(0, Math.min(progress, 100));
        if (this.progress == progress) {
            return;
        }
        this.progress = progress;
        this.updateImage();
    }

    public void setProgressState(int progressState) {
        this.checkWidget();
        if (this.progressState == progressState) {
            return;
        }
        this.progressState = progressState;
        this.updateImage();
    }

    void updateImage() {
        boolean drawImage;
        boolean drawProgress = this.progress != 0 && this.progressState != -1;
        boolean drawIntermidiate = this.progressState == 2;
        NSApplication app = NSApplication.sharedApplication();
        NSDockTile dock = app.dockTile();
        boolean bl = drawImage = this.overlayImage != null && dock.badgeLabel() == null;
        if (!(drawImage || drawProgress || drawIntermidiate)) {
            app.setApplicationIconImage(this.defaultImage);
            return;
        }
        NSSize size = this.defaultImage.size();
        NSImage newImage = (NSImage)new NSImage().alloc();
        newImage = newImage.initWithSize(size);
        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        rep = rep.initWithBitmapDataPlanes(0L, (int)size.width, (int)size.height, 8L, 4L, true, false, OS.NSDeviceRGBColorSpace, 3L, (int)size.width * 4, 32L);
        newImage.addRepresentation(rep);
        rep.release();
        NSRect rect = new NSRect();
        rect.height = size.height;
        rect.width = size.width;
        newImage.lockFocus();
        this.defaultImage.drawInRect(rect, rect, 2L, 1.0);
        if (drawImage) {
            NSImage badgetImage = this.overlayImage.handle;
            NSSize badgeSize = badgetImage.size();
            NSRect srcRect = new NSRect();
            srcRect.height = badgeSize.height;
            srcRect.width = badgeSize.width;
            NSRect dstRect = new NSRect();
            dstRect.x = size.width / 2.0;
            dstRect.height = size.height / 2.0;
            dstRect.width = size.width / 2.0;
            badgetImage.drawInRect(dstRect, srcRect, 2L, 1.0);
        }
        if (drawIntermidiate || drawProgress) {
            int count;
            switch (this.progressState) {
                case 1: {
                    NSColor.colorWithDeviceRed(1.0, 0.0, 0.0, 0.6f).setFill();
                    break;
                }
                case 4: {
                    NSColor.colorWithDeviceRed(1.0, 1.0, 0.0, 0.6f).setFill();
                    break;
                }
                default: {
                    NSColor.colorWithDeviceRed(1.0, 1.0, 1.0, 0.6f).setFill();
                }
            }
            rect.width = size.width / 13.0;
            rect.height = size.height / 3.0;
            if (drawIntermidiate) {
                count = this.iProgress;
                this.iProgress = (this.iProgress + 1) % 8;
                this.getDisplay().timerExec(350, () -> this.updateImage());
            } else {
                count = this.progress * 7 / 100;
            }
            int i = 0;
            while (i <= count) {
                rect.x = (double)(i * 2) * rect.width;
                NSBezierPath.fillRect(rect);
                ++i;
            }
        }
        newImage.unlockFocus();
        app.setApplicationIconImage(newImage);
        newImage.release();
    }
}

